<?php
/* --------------------------------------------------------------
   remove_admin_access_from_non_admins.php 2025-02-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2025 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

/** @var DatabaseModel $this */
/** @var int $t_success */
$payOneConfigQuery = "SELECT `value` FROM gx_configurations WHERE `key` = 'configuration/MODULE_PAYMENT_INSTALLED';";


$result = $this->query($payOneConfigQuery, true);

$result = mysqli_fetch_array($result)[0];

$modulePaymentInstalled = explode(';', $result);

$filteredModules = array_filter($modulePaymentInstalled, function (string $module) {
    return !str_starts_with($module, 'payone_');
});

$payOneConfigUpdateQuery = "UPDATE gx_configurations SET value = :value WHERE `key` = 'configuration/MODULE_PAYMENT_INSTALLED';";

$payOneConfigParam = implode(';', $filteredModules);

$payOneConfigUpdateQuery = str_replace(':value', '"' . $payOneConfigParam . '"', $payOneConfigUpdateQuery);

$t_success &= $this->query($payOneConfigUpdateQuery,true);

$deleteQueries = [
    "DELETE FROM admin_access_group_items WHERE identifier LIKE '%PAYONE%';",
    "DROP TABLE IF EXISTS `payone_ac_cache`;",
    "DROP TABLE IF EXISTS `payone_api_log`;",
    "DROP TABLE IF EXISTS `payone_clearingdata`;",
    "DROP TABLE IF EXISTS `payone_cr_cache`;",
    "DROP TABLE IF EXISTS `payone_transactions`;",
    "DROP TABLE IF EXISTS `payone_transactions_log`;",
    "DROP TABLE IF EXISTS `payone_txstatus`;",
    "DROP TABLE IF EXISTS `payone_txstatus_data`;"
];

foreach ($deleteQueries as $query) {
    $t_success &= $this->query($query, true);
}
